<div class="table-responsive p-20">


    <div class="alert alert-danger d-none" id="custom-module-alert"></div>

    @includeIf('languagepack::module-activated-alert')

    @if ($universalBundle)
    <div class='card border mb-4'>
        <div class="card-body bg-white border-0 pt-4">
            <div class="row">
                <div class="col-md-8">
                    <div class="d-flex align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 148.319 148.319">
                            <g id="Group_1192" data-name="Group 1192" transform="translate(0 0)">
                              <path id="Path_1092" data-name="Path 1092" d="M222.36,482h8.691v8.691H222.36Z" transform="translate(-157.945 -342.371)" fill="#fc6"/>
                              <path id="Path_1093" data-name="Path 1093" d="M0,259.64H8.691v8.691H0Z" transform="translate(0 -184.426)" fill="#ffe666"/>
                              <path id="Path_1094" data-name="Path 1094" d="M87.9,343.049H96.6v8.691H87.9ZM24.383,368.021c10.842-10.485,22.345,1.1,22.345,1.1,30.347-8.212,29.264-38.96,29.264-38.96L64.876,310.85,20.835,363.085A21.736,21.736,0,0,0,24.383,368.021Z" transform="translate(-14.799 -220.801)" fill="#fc6"/>
                              <path id="Path_1095" data-name="Path 1095" d="M.755,329.786l8.483,5.51c-7.059,8.145-5.2,15.831-2.667,20.6L54.71,307.76,39.5,300.74s-30.53-1.3-38.741,29.046Z" transform="translate(-0.536 -213.614)" fill="#ffe666"/>
                              <path id="Path_1096" data-name="Path 1096" d="M138.662,330.161l-11.117-19.31-18.483,26.676A32.686,32.686,0,0,0,138.662,330.161Z" transform="translate(-77.469 -220.802)" fill="#cc295f"/>
                              <path id="Path_1097" data-name="Path 1097" d="M106.7,330.359l22.579-22.579-15.213-7.02A32.686,32.686,0,0,0,106.7,330.359Z" transform="translate(-75.108 -213.634)" fill="#f37"/>
                              <path id="Path_1098" data-name="Path 1098" d="M172.865,302.977l11.117,11.117,6.553-6.553-11.117-19.31Z" transform="translate(-122.788 -204.734)" fill="#cfcfe6"/>
                              <path id="Path_1099" data-name="Path 1099" d="M141.043,278.14l-6.552,6.553,11.116,11.117,10.649-10.649Z" transform="translate(-95.531 -197.567)" fill="#ece6f2"/>
                              <path id="Path_1100" data-name="Path 1100" d="M213.154,284.922l-11.117-19.31-6.552,14.746L206.6,291.475Z" transform="translate(-138.856 -188.668)" fill="#a3aacc"/>
                              <path id="Path_1101" data-name="Path 1101" d="M163.662,255.521l-6.552,6.552,11.117,11.117,10.649-10.649Z" transform="translate(-111.597 -181.5)" fill="#cfcfe6"/>
                              <path id="Path_1102" data-name="Path 1102" d="M312.615,257.181c4.392,17.012-20.209,41.613-20.209,41.613L279.1,285.486l14.1-25.1Z" transform="translate(-198.247 -182.679)" fill="#cc295f"/>
                              <path id="Path_1103" data-name="Path 1103" d="M152.784,115.913c-17.012-4.392-41.613,20.209-41.613,20.209l13.308,13.308,25.1-14.1Z" transform="translate(-78.966 -81.961)" fill="#f37"/>
                              <path id="Path_1104" data-name="Path 1104" d="M390.679,9.65,345.137,47l29.646,21.452a55.305,55.305,0,0,0,15.9-58.8Z" transform="translate(-245.156 -6.854)" fill="#cc295f"/>
                              <path id="Path_1105" data-name="Path 1105" d="M299.369,18.692l17.355,25.549L358.17,2.8A55.305,55.305,0,0,0,299.369,18.692Z" transform="translate(-212.646 0)" fill="#f37"/>
                              <path id="Path_1106" data-name="Path 1106" d="M263.1,138.579l-26.593,18.4-18.4,26.593,17.669,17.669,47.844-40.4q.471-.4.932-.807Z" transform="translate(-154.922 -98.435)" fill="#ece6f2"/>
                              <path id="Path_1107" data-name="Path 1107" d="M198.32,64.526q-.409.462-.807.932L157.11,113.3l17.669,17.669,44.993-44.993Z" transform="translate(-111.597 -45.834)" fill="#fff5f5"/>
                              <path id="Path_1108" data-name="Path 1108" d="M357.067,122.224a15.946,15.946,0,0,0,0-22.526l-15.36,7.166-7.166,15.36A15.946,15.946,0,0,0,357.067,122.224Z" transform="translate(-237.629 -70.817)" fill="#101040"/>
                              <path id="Path_1109" data-name="Path 1109" d="M323.12,88.277a15.946,15.946,0,0,0,0,22.526l22.526-22.526A15.947,15.947,0,0,0,323.12,88.277Z" transform="translate(-226.208 -59.396)" fill="#283366"/>
                              <path id="Path_1110" data-name="Path 1110" d="M365.991,131.147a7.246,7.246,0,0,0,0-10.236l-7.166,3.07-3.07,7.166A7.245,7.245,0,0,0,365.991,131.147Z" transform="translate(-252.698 -85.885)" fill="#cfcfe6"/>
                              <path id="Path_1111" data-name="Path 1111" d="M350.564,115.722a7.246,7.246,0,0,0,0,10.236L360.8,115.722A7.246,7.246,0,0,0,350.564,115.722Z" transform="translate(-247.507 -80.695)" fill="#ece6f2"/>
                            </g>
                        </svg>

                        <span class="h5 mb-0 mx-2">{{ $universalBundle->getName() }}</span>
                            @if (config(strtolower($universalBundle) . '.setting'))
                                @if (isset($version[config(strtolower($universalBundle) . '.envato_item_id')]))
                                    @if ($version[config(strtolower($universalBundle) . '.envato_item_id')] > File::get($universalBundle->getPath() . '/version.txt'))
                                        <span class="badge badge-danger" data-toggle="tooltip"
                                            data-original-title="@lang('app.moduleUpdateMessage', ['name' => $universalBundle->getName(), 'version' => $version[config(strtolower($universalBundle) . '.envato_item_id')]])">
                                            {{ File::get($universalBundle->getPath() . '/version.txt') }}
                                        </span>
                                    @else
                                        <span class="badge badge-success">
                                            {{ File::get($universalBundle->getPath() . '/version.txt') }}
                                        </span>
                                    @endif
                                @else
                                    <span class="badge badge-success">{{ File::get($universalBundle->getPath() . '/version.txt') }}</span>
                                @endif
                            @endif
                            <div class="d-inline ml-3">
                                @if (in_array($universalBundle, $worksuitePlugins))

                                    @if (config(strtolower($universalBundle) . '.setting'))
                                        @php
                                            $settingInstance = config(strtolower($universalBundle) . '.setting');

                                            $fetchSetting = $settingInstance::first();
                                        @endphp

                                        @if (config(strtolower($universalBundle) . '.verification_required'))
                                            @if ($fetchSetting->purchase_code)
                                                <span class="blur-code purchase-code">{{ $fetchSetting->purchase_code }}</span>
                                                <div class="show-hide-purchase-code d-inline" data-toggle="tooltip"
                                                        data-original-title="{{__('messages.showHidePurchaseCode')}}">
                                                    <i class="icon far fa-eye-slash cursor-pointer"></i>
                                                </div>
                                                <div class="verify-module d-inline" data-toggle="tooltip"
                                                        data-original-title="{{__('messages.changePurchaseCode')}}"
                                                        data-module="{{ strtolower($universalBundle) }}"
                                                >
                                                    <i class="icon far fa-edit cursor-pointer"></i>
                                                </div>
                                            @else
                                                <a href="javascript:;" class="verify-module f-w-500"
                                                    data-module="{{ strtolower($universalBundle) }}">@lang('app.verifyEnvato')</a>
                                            @endif
                                        @endif
                                    @endif
                                @endif

                            </div>
                    </div>
                </div>
                <div class="col-md-4 text-right">
                    {{-- @if (config(strtolower($universalBundle) . '.setting') && isset($version[config(strtolower($universalBundle) . '.envato_item_id')]))
                        @if ($version[config(strtolower($universalBundle) . '.envato_item_id')] > File::get($universalBundle->getPath() . '/version.txt'))
                        <button type="button" class="btn btn-primary btn-sm update-module px-2 py-1">
                            @lang('app.update')
                        </button>
                        @else
                            --
                        @endif
                    @endif --}}
                    @if (!config(strtolower($universalBundle) . '.setting'))
                        <div class="custom-control custom-switch"  data-toggle="tooltip"
                            data-original-title="@lang('app.moduleSwitchMessage', ['name' => $universalBundle])">
                            <input type="checkbox" class="custom-control-input change-module-status"
                                id="module-{{ $universalBundle }}" data-module-name="{{ $universalBundle }}">
                            <label class="custom-control-label cursor-pointer" for="module-{{ $universalBundle }}"></label>
                        </div>
                    @endif
                </div>
            </div>

        </div>

    </div>
    @includeIf('universalbundle::install-modules')
    @endif

    <x-table class="table-bordered table-hover custom-modules-table" headType="thead-light">
        <x-slot name="thead">
            <th>@lang('app.name')</th>
            <th>@lang('app.purchaseCode')</th>
            <th>@lang('app.moduleVersion')</th>
            {{-- <th class="text-center">@lang('app.updateModule')</th> --}}
            <th class="text-right">@lang('app.status')</th>
        </x-slot>

        @forelse ($allModules as $key=>$module)
            <tr>
                <td>{{ $key }}
                    @if (module_enabled('UniversalBundle') && isInstallFromUniversalBundleModule($key))
                            <i class="icon text-info fas fa-info-circle cursor-pointer" data-toggle="tooltip"
                              data-original-title="{{__('universalbundle::app.moduleInfo')}}"></i>
                    @endif
                </td>
                <td>
                    @if (in_array($module, $worksuitePlugins))

                        @if (config(strtolower($module) . '.setting'))
                            @php
                                $settingInstance = config(strtolower($module) . '.setting');

                                $fetchSetting = $settingInstance::first();
                            @endphp

                            @if (config(strtolower($module) . '.verification_required'))
                                @if ($fetchSetting->purchase_code)
                                    <span class="blur-code purchase-code">{{ $fetchSetting->purchase_code }}</span>
                                    <div class="show-hide-purchase-code d-inline" data-toggle="tooltip"
                                         data-original-title="{{__('messages.showHidePurchaseCode')}}">
                                        <i class="icon far fa-eye-slash cursor-pointer"></i>
                                    </div>
                                    <div class="verify-module d-inline" data-toggle="tooltip"
                                         data-original-title="{{__('messages.changePurchaseCode')}}"
                                         data-module="{{ strtolower($module) }}"
                                    >
                                        <i class="icon far fa-edit cursor-pointer"></i>
                                    </div>
                                @else
                                    <a href="javascript:;" class="verify-module f-w-500"
                                       data-module="{{ strtolower($module) }}">@lang('app.verifyEnvato')</a>
                                @endif
                            @endif
                        @endif
                    @endif
                </td>
                <td>
                    @if (config(strtolower($module) . '.setting'))
                        @if (isset($version[config(strtolower($module) . '.envato_item_id')]))
                            @if ($version[config(strtolower($module) . '.envato_item_id')] > File::get($module->getPath() . '/version.txt'))
                                <span class="badge badge-danger" data-toggle="tooltip"
                                    data-original-title="@lang('app.moduleUpdateMessage', ['name' => $module->getName(), 'version' => $version[config(strtolower($module) . '.envato_item_id')]])">
                                    {{ File::get($module->getPath() . '/version.txt') }}
                                </span>
                            @else
                                <span class="badge badge-success">
                                    {{ File::get($module->getPath() . '/version.txt') }}
                                </span>
                            @endif
                        @else
                            <span class="badge badge-success">{{ File::get($module->getPath() . '/version.txt') }}</span>
                        @endif
                    @endif

                </td>
                {{-- <td class="text-center">
                    @if (config(strtolower($module) . '.setting') && isset($version[config(strtolower($module) . '.envato_item_id')]))
                        @if ($version[config(strtolower($module) . '.envato_item_id')] > File::get($module->getPath() . '/version.txt'))
                        <button type="button" class="btn btn-primary btn-sm update-module px-2 py-1">
                            @lang('app.update')
                        </button>
                        @else
                            --
                        @endif
                    @endif
                </td> --}}
                <td class="text-right">
                    <div class="custom-control custom-switch"  data-toggle="tooltip"
                         data-original-title="@lang('app.moduleSwitchMessage', ['name' => $module])">
                        <input type="checkbox" @if (in_array($module, $worksuitePlugins)) checked
                               @endif class="custom-control-input change-module-status"
                               id="module-{{ $key }}" data-module-name="{{ $module }}">
                        <label class="custom-control-label cursor-pointer" for="module-{{ $key }}"></label>
                    </div>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="5">
                    <x-cards.no-record icon="calendar" :message="__('messages.noRecordFound')"/>
                </td>
            </tr>
        @endforelse

    </x-table>

    @include('vendor.froiden-envato.update.plugins', ['allModules' => $allModules])
</div>

<script>
    $('body').on('change', '.change-module-status', function () {
        let moduleStatus;
        const module = $(this).data('module-name');

        if ($(this).is(':checked')) {
            moduleStatus = 'active';
        } else {
            moduleStatus = 'inactive';
        }

        let url = "{{ route('custom-modules.update', ':module') }}";
        url = url.replace(':module', module);

        $('#custom-module-alert').addClass('d-none');

        $.easyAjax({
            url: url,
            type: "POST",
            disableButton: true,
            buttonSelector: ".change-module-status",
            container: '.custom-modules-table',
            blockUI: true,
            data: {
                'id': module,
                'status': moduleStatus,
                '_method': 'PUT',
                '_token': '{{ csrf_token() }}'
            },
            error: function (response) {
                if (response.responseJSON) {
                    $('#custom-module-alert').html(response.responseJSON.message).removeClass('d-none');
                    $('#module-' + module).prop('checked', false);
                }

            }
        });
    });

    $('body').on('click', '.verify-module', function () {
        const module = $(this).data('module');
        let url = "{{ route('custom-modules.show', ':module') }}";
        url = url.replace(':module', module);
        $(MODAL_LG + ' ' + MODAL_HEADING).html('...');
        $.ajaxModal(MODAL_LG, url);
    });

</script>
